import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;

public class HttpHead extends MIDlet implements CommandListener  {
  // URL par dfaut
  private static String defaultURL = "http://j2me.netinnovations.fr/Livre/HttpGet.asp";
  // Zone de saisie de l'URL
  private Display myDisplay = null;
  private Form mainScreen;
  private TextField requestField;
  // Zone de texte affichant les informations sur les enttes
  private Form resultScreen;
  private StringItem resultField;
  // Commande "envoie"
  Command sendCommand = new Command("Envoi", Command.OK, 1);
  // Commande "retour"
  Command backCommand = new Command("Retour", Command.OK, 1);

  public HttpHead(){
    // Initialisation de l'interface utilisateur
    myDisplay = Display.getDisplay(this);
    mainScreen = new Form("Entrez une URL:");
    requestField = new TextField(null, defaultURL, 50, TextField.URL);
    mainScreen.append(requestField);
    mainScreen.addCommand(sendCommand);
    mainScreen.setCommandListener(this);
  }

  public void startApp() {
    myDisplay.setCurrent(mainScreen);
  }

  public void pauseApp() {
  }

  public void destroyApp(boolean unconditional) {
  }

  public void commandAction(Command c, Displayable s) {
    // L'utilisateur a active la commande "envoie"
    if (c == sendCommand) {
      // Rcupration des enttes
      String urlstring = requestField.getString();
      // recuperation de l'URL saisie
      String resultstring = sendHeadRequest(urlstring);
      // Affichage des enttes obtenues du serveur HTTP
      resultScreen = new Form("Resultat:");
      resultField  = new StringItem(null, resultstring);
      resultScreen.append(resultField);
      resultScreen.addCommand(backCommand);
      resultScreen.setCommandListener(this);
      myDisplay.setCurrent(resultScreen);
    } else if (c == backCommand) {
      // On reprend au dbut
      requestField.setString(defaultURL);
      myDisplay.setCurrent(mainScreen); 
    }
  }

  public String sendHeadRequest(String urlstring) {
    HttpConnection hc = null;
    InputStream is = null;
    String message = "";
    try {
      // Ouverture d'une connexion HTTP avec le serveur Web
      hc = (HttpConnection) Connector.open(urlstring);
      // Slection de la mthode HEAD
      hc.setRequestMethod(HttpConnection.HEAD);
      // Etablissement du flux en entre depuis la connexion
      is = hc.openInputStream();
      // Rcupration des paires de valeur depuis les enttes HTTP
      int i = 1;
      String key = "";
      String value = "";
      while ( (value = hc.getHeaderField(i)) != null) {
        key = hc.getHeaderFieldKey(i++);
        message = message + key + ":" + value + "\n";
      }
    } catch (IOException ioe) {
      message = message + ioe.getMessage();
    } finally {
      try { if (hc != null) hc.close();} catch (IOException ignored) {}
      try { if (is != null) is.close();} catch (IOException ignored) {} 
    }
    return message;
  }
}
